<?php

namespace Import\ApiBundle\Services\Import;


class ImportSessionInvestmentFunds extends ImportMainService
{
    protected $urlZip = 'http://bossa.pl/pub/fundinwest/mstock/sesjafun/few_last.zip';

    protected $columns = array("Name","Date","Open","High","Low","Close","Volume");

    protected $type = 'InvestmentFunds';

    public function import()
    {
        $data = $this->getCSVFromZip($this->urlZip,$this->type,$this->columns);

        $i = 0;
        foreach($data as $row)
        {
            $this->save($row);
            $i++;
        }

        $this->getDoctrine()->getEntityManager()->flush();
        $this->viewErrors();

        return array('count' => $i);
    }

    protected function save($data)
    {
        $data['InvestmentFunds'] = $this->getInvestmentFundsBySymbol($data['Name']);
        $SessionIndexGPW = $this->getDoctrine()->getRepository('ImportApiBundle:SessionInvestmentFunds')->add($data);

        return $SessionIndexGPW;
    }
}